<?php
if(!function_exists('grupi_configs')){
    function grupi_configs($value){
         
        $configs = [
            'theme_colors' => [
                'primary'   => [
                    'title' => esc_html__('Primary', 'grupi'), 
                    'value' => grupi_get_opt('primary_color', '#f9bd0e')
                ],
                'secondary'   => [
                    'title' => esc_html__('Secondary', 'grupi'), 
                    'value' => grupi_get_opt('secondary_color', '#151515')
                ],
                'm_gradient_color1'   => [
                    'title' => esc_html__('Gradient Color 1', 'grupi'), 
                    'value' => grupi_get_opt('m_gradient_color1')
                ],
                'm_gradient_color2'   => [
                    'title' => esc_html__('Gradient Color 2', 'grupi'), 
                    'value' => grupi_get_opt('m_gradient_color2')
                ],
                'm_gradient_color3'   => [
                    'title' => esc_html__('Gradient Color 3', 'grupi'), 
                    'value' => grupi_get_opt('m_gradient_color3')
                ],
                'm_gradient_color4'   => [
                    'title' => esc_html__('Gradient Color 4', 'grupi'), 
                    'value' => grupi_get_opt('m_gradient_color4')
                ],
                'm_gradient_color5'   => [
                    'title' => esc_html__('Gradient Color 5', 'grupi'), 
                    'value' => grupi_get_opt('m_gradient_color5')
                ]
            ],
            'link' => [
                'color' => grupi_get_opt('link_color', ['regular' => '#f9bd0e'])['regular'],
                'color-hover'   => grupi_get_opt('link_color', ['hover' => '#ffde00'])['hover'],
                'color-active'  => grupi_get_opt('link_color', ['active' => '#ffde00'])['active'],
            ],
            'gradient' => [
                'color-from' => grupi_get_opt('gradient_color', ['from' => '#f4a21a'])['from'],
                'color-to' => grupi_get_opt('gradient_color', ['to' => '#ffde00'])['to'],
            ],
               
        ];
        return $configs[$value];
    }
}
if(!function_exists('grupi_inline_styles')) {
    function grupi_inline_styles() {  
        
        $theme_colors      = grupi_configs('theme_colors');
        $link_color        = grupi_configs('link');
        $gradient_color        = grupi_configs('gradient');
        ob_start();
        echo ':root{';
            
            foreach ($theme_colors as $color => $value) {
                printf('--%1$s-color: %2$s;', str_replace('#', '',$color),  $value['value']);
            }
            foreach ($theme_colors as $color => $value) {
                printf('--%1$s-color-rgb: %2$s;', str_replace('#', '',$color),  grupi_hex_rgb($value['value']));
            }
            foreach ($link_color as $color => $value) {
                printf('--link-%1$s: %2$s;', $color, $value);
            } 
            foreach ($gradient_color as $color => $value) {
                printf('--gradient-%1$s: %2$s;', $color, $value);
            }
            foreach ($gradient_color as $color => $value) {
                printf('--gradient-%1$s-rgb: %2$s;', $color, grupi_hex_rgb($value));
            }
        echo '}';

        return ob_get_clean();
         
    }
}
 