<?php
if ( ! class_exists( 'ReduxFrameworkInstances' ) ) {
	return;
}

if(!function_exists('grupi_hex_to_rgba')){
    function grupi_hex_to_rgba($hex,$opacity = 1) {
        $hex = str_replace("#",null, $hex);
        $color = array();
        if(strlen($hex) == 3) {
            $color['r'] = hexdec(substr($hex,0,1).substr($hex,0,1));
            $color['g'] = hexdec(substr($hex,1,1).substr($hex,1,1));
            $color['b'] = hexdec(substr($hex,2,1).substr($hex,2,1));
            $color['a'] = $opacity;
        }
        else if(strlen($hex) == 6) {
            $color['r'] = hexdec(substr($hex, 0, 2));
            $color['g'] = hexdec(substr($hex, 2, 2));
            $color['b'] = hexdec(substr($hex, 4, 2));
            $color['a'] = $opacity;
        }
        $color = "rgba(".implode(', ', $color).")";
        return $color;
    }
}

class CSS_Generator {
	/**
     * scssc class instance
     *
     * @access protected
     * @var scssc
     */
    protected $scssc = null;

    /**
     * ReduxFramework class instance
     *
     * @access protected
     * @var ReduxFramework
     */
    protected $redux = null;

    /**
     * Debug mode is turn on or not
     *
     * @access protected
     * @var boolean
     */
    protected $dev_mode = true;

    /**
     * opt_name of ReduxFramework
     *
     * @access protected
     * @var string
     */
    protected $opt_name = '';

	/**
	 * Constructor
	 */

	function __construct() {
		$this->opt_name = grupi_get_opt_name();
		if ( empty( $this->opt_name ) ) {
			return;
		}
		$this->dev_mode = grupi_get_opt( 'dev_mode', '0' ) === '1' ? true : false;
		add_filter( 'ct_scssc_on', '__return_true' );
		add_action( 'init', array( $this, 'init' ) );
		add_action( 'wp_enqueue_scripts', array( $this, 'enqueue' ), 20 );
	}

	/**
	 * init hook - 10
	 */
	function init() {
		if ( ! class_exists( 'scssc' ) ) {
			return;
		}

		$this->redux = ReduxFrameworkInstances::get_instance( $this->opt_name );

		if ( empty( $this->redux ) || ! $this->redux instanceof ReduxFramework ) {
			return;
		}
		add_action( 'wp', array( $this, 'generate_with_dev_mode' ) );
		add_action( "redux/options/{$this->opt_name}/saved", function () {
			$this->generate_file_options();
		} );
	}

	function generate_with_dev_mode() {
		if ( $this->dev_mode === true ) {
			$this->generate_file_options();
			$this->generate_file();
		}
	}

	function generate_file_options() {
		$scss_dir = get_template_directory() . '/assets/scss/';
        $this->scssc = new scssc();
        $this->scssc->setImportPaths( $scss_dir );
        $_options = $scss_dir . 'variables.scss';
        $this->scssc->setFormatter( 'scss_formatter' );
        $this->redux->filesystem->execute( 'put_contents', $_options, array(
            'content' => preg_replace( "/(?<=[^\r]|^)\n/", "\r\n", $this->options_output() )
        ) );
	}

	/**
	 * Generate options and css files
	 */
	function generate_file() {
		$scss_dir = get_template_directory() . '/assets/scss/';
		$css_dir  = get_template_directory() . '/assets/css/';

		$this->scssc = new scssc();
		$this->scssc->setImportPaths( $scss_dir );

		$css_file = $css_dir . 'theme.css';

		$this->scssc->setFormatter( 'scss_formatter' );
		$this->redux->filesystem->execute( 'put_contents', $css_file, array(
			'content' => preg_replace( "/(?<=[^\r]|^)\n/", "\r\n", $this->scssc->compile( '@import "theme.scss"' ) )
		) );
	}

	protected function print_scss_opt_colors($variable,$param){
        if(is_array($variable)){
            $k = [];
            $v = [];
            foreach ($variable as $key => $value) {
                $k[] = str_replace('-', '_', $key);
                $v[] = 'var(--'.str_replace(['#',' '], [''],$key).'-color)';
            }
            if($param === 'key'){
                return implode(',', $k);
            }else{
                return implode(',', $v);
            }
            
        } else {
            return $variable;
        }
    }

	/**
	 * Output options to _variables.scss
	 *
	 * @access protected
	 * @return string
	 */
	protected function options_output() {
		$theme_colors                    = grupi_configs('theme_colors');
        $links                           = grupi_configs('link');
        $gradients                           = grupi_configs('gradient');
		ob_start();

		printf('$grupi_theme_colors_key:(%s);',$this->print_scss_opt_colors($theme_colors,'key'));
        printf('$grupi_theme_colors_val:(%s);',$this->print_scss_opt_colors($theme_colors,'val'));
        // color rgb only
        foreach ($theme_colors as $key => $value) {
            printf('$%1$s_color_hex: %2$s;', str_replace('-', '_', $key), $value['value']); 
        }
        // color
        foreach ($theme_colors as $key => $value) {
            printf('$%1$s_color: %2$s;', str_replace('-', '_', $key), 'var(--'.str_replace(['#',' '], [''],$key).'-color)' );
        }

        // color rgb only
        foreach ($theme_colors as $key => $value) {
            printf('$%1$s_color_hex: %2$s;', str_replace('-', '_', $key), $value['value']); 
        }
        // color
        foreach ($theme_colors as $key => $value) {
            printf('$%1$s_color: %2$s;', str_replace('-', '_', $key), 'var(--'.str_replace(['#',' '], [''],$key).'-color)' );
        }
         
        // link color
        foreach ($links as $key => $value) {
            printf('$link_%1$s: %2$s;', str_replace('-', '_', $key), 'var(--link-'.$key.')');
        }

        // gradient color
        foreach ($gradients as $key => $value) {
            printf('$gradient_%1$s: %2$s;', str_replace('-', '_', $key), 'var(--gradient-'.$key.')');
        }

        // gradient color hex
        /* Gradient Color Main */
        $gradient_color_hex = grupi_get_opt( 'gradient_color' );
        if ( !empty($gradient_color_hex['from']) && isset($gradient_color_hex['from']) ) {
            printf( '$gradient_from_hex: %s;', esc_attr( $gradient_color_hex['from'] ) );
        } else {
            echo '$gradient_from_hex: #8d4cfa;';
        }
        if ( !empty($gradient_color_hex['to']) && isset($gradient_color_hex['to']) ) {
            printf( '$gradient_to_hex: %s;', esc_attr( $gradient_color_hex['to'] ) );
        } else {
            echo '$gradient_to_hex: #5f6ffb;';
        }

		/* Font */
		$body_default_font = grupi_get_opt( 'body_default_font', 'Roboto' );
		if ( isset( $body_default_font ) ) {
			echo '
                $body_default_font: ' . esc_attr( $body_default_font ) . ';
            ';
		}

		$heading_default_font = grupi_get_opt( 'heading_default_font', 'Libre-Caslon-Text' );
		if ( isset( $heading_default_font ) ) {
			echo '
                $heading_default_font: ' . esc_attr( $heading_default_font ) . ';
            ';
		}

		return ob_get_clean();
	}

	/**
	 * Hooked wp_enqueue_scripts - 20
	 * Make sure that the handle is enqueued from earlier wp_enqueue_scripts hook.
	 */
	function enqueue() {
		$css = $this->inline_css();
		if ( ! empty( $css ) ) {
			wp_add_inline_style( 'grupi-theme', $css );
		}
	}

	/**
	 * Generate inline css based on theme options
	 */
	protected function inline_css() {
		ob_start();

		/* Logo */ ?>
        @media screen and (max-width: 1199px) {
		<?php
			$logo_maxh_sm = grupi_get_opt( 'logo_maxh_sm' );
			if ( ! empty( $logo_maxh_sm['height'] ) && $logo_maxh_sm['height'] != 'px' ) {
				printf( '.ct-header-mobile .ct-header-branding img { max-height: %s !important; }', esc_attr( $logo_maxh_sm['height'] ) );
			} ?>
        }
        <?php /* End Logo */

		/* Menu */ ?>
		@media screen and (min-width: 1200px) {
		<?php  
			$topbar_bg_color = grupi_get_opt( 'topbar_bg_color' );
			$header_bg_color = grupi_get_opt( 'header_bg_color' );
			if ( ! empty( $topbar_bg_color ) ) {
				printf( '#ct-header-top { background-color: %s !important; }', esc_attr( $topbar_bg_color ) );
			}

			if ( ! empty( $header_bg_color ) ) {
				printf( '#ct-header-wrap #ct-header, #ct-header-wrap #ct-header .ct-header-navigation-bg { background-color: %s !important; }', esc_attr( $header_bg_color ) );
				printf( '#ct-header-wrap.ct-header-layout3 #ct-header { background-color: transparent !important; }', esc_attr( $header_bg_color ) );

				printf( '#ct-header-wrap.ct-header-layout3 #ct-header.h-fixed { background-color: %s !important; }', esc_attr( $header_bg_color ) );
				printf( '#ct-header-wrap.ct-header-layout3 #ct-header.h-fixed .ct-header-navigation-bg { background-color: transparent !important; }', esc_attr( $header_bg_color ) );
			}

			$main_menu_color = grupi_get_opt( 'main_menu_color' );
			if ( ! empty( $main_menu_color['regular'] ) ) {
				printf( '.ct-main-menu > li > a { color: %s !important; }', esc_attr( $main_menu_color['regular'] ) );
			}
			if ( ! empty( $main_menu_color['hover'] ) ) {
				printf( '.ct-main-menu > li > a:hover { color: %s !important; }', esc_attr( $main_menu_color['hover'] ) );
			}
			if ( ! empty( $main_menu_color['active'] ) ) {
				printf( '.ct-main-menu > li.current_page_item > a, .ct-main-menu > li.current-menu-item > a, .ct-main-menu > li.current_page_ancestor > a, .ct-main-menu > li.current-menu-ancestor > a { color: %s !important; }', esc_attr( $main_menu_color['active'] ) );
			}
			$sticky_menu_color = grupi_get_opt( 'sticky_menu_color' );
			if ( ! empty( $sticky_menu_color['regular'] ) ) {
				printf( '#ct-header.h-fixed .ct-main-menu > li > a { color: %s !important; }', esc_attr( $sticky_menu_color['regular'] ) );
			}
			if ( ! empty( $sticky_menu_color['hover'] ) ) {
				printf( '#ct-header.h-fixed .ct-main-menu > li > a:hover { color: %s !important; }', esc_attr( $sticky_menu_color['hover'] ) );
			}
			if ( ! empty( $sticky_menu_color['active'] ) ) {
				printf( '#ct-header.h-fixed .ct-main-menu > li.current_page_item > a, #ct-header.h-fixed .ct-main-menu > li.current-menu-item > a, #ct-header.h-fixed .ct-main-menu > li.current_page_ancestor > a, #ct-header.h-fixed .ct-main-menu > li.current-menu-ancestor > a { color: %s !important; }', esc_attr( $sticky_menu_color['active'] ) );
			}
			$sub_menu_color = grupi_get_opt( 'sub_menu_color' );
			if ( ! empty( $sub_menu_color['regular'] ) ) {
				printf( '#ct-header .ct-main-menu .sub-menu > li > a { color: %s !important; }', esc_attr( $sub_menu_color['regular'] ) );
			}
			if ( ! empty( $sub_menu_color['hover'] ) ) {
				printf( '#ct-header .ct-main-menu .sub-menu > li > a:hover { color: %s !important; }', esc_attr( $sub_menu_color['hover'] ) );
				printf( '#ct-header .ct-main-menu .sub-menu > li > a:before { background-color: %s !important; }', esc_attr( $sub_menu_color['hover'] ) );
			}
			if ( ! empty( $sub_menu_color['active'] ) ) {
				printf( '#ct-header .ct-main-menu .sub-menu > li.current_page_item > a, #ct-header .ct-main-menu .sub-menu > li.current-menu-item > a, #ct-header .ct-main-menu .sub-menu > li.current_page_ancestor > a, #ct-header .ct-main-menu .sub-menu > li.current-menu-ancestor > a { color: %s !important; }', esc_attr( $sub_menu_color['active'] ) );
				printf( '#ct-header .ct-main-menu .sub-menu > li.current_page_item > a:before, #ct-header .ct-main-menu .sub-menu > li.current-menu-item > a:before, #ct-header .ct-main-menu .sub-menu > li.current_page_ancestor > a:before, #ct-header .ct-main-menu .sub-menu > li.current-menu-ancestor > a:before { background-color: %s !important; }', esc_attr( $sub_menu_color['active'] ) );
			}
			$menu_icon_color = grupi_get_opt( 'menu_icon_color' );
			if ( ! empty( $menu_icon_color ) ) {
				printf( '.ct-main-menu .link-icon { color: %s !important; }', esc_attr( $menu_icon_color ) );
			}
			?>
		}
		<?php /* End Menu */

		/* Page Title */
		$ptitle_bg = grupi_get_page_opt( 'ptitle_bg' );
		$custom_pagetitle = grupi_get_page_opt( 'custom_pagetitle', 'themeoption' );
		if ( $custom_pagetitle == 'show' && ! empty( $ptitle_bg['background-image'] ) ) {
			echo 'body .site #ct-pagetitle.ct-pagetitle {
                background-image: url(' . esc_attr( $ptitle_bg['background-image'] ) . ');
            }';
		}
		if ( $custom_pagetitle == 'show' && ! empty( $ptitle_bg['background-color'] ) ) {
			echo 'body .site #ct-pagetitle.ct-pagetitle {
                background-color: '. esc_attr( $ptitle_bg['background-color'] ) .';
            }';
		}

		/* Preset */
		$p_primary_color = grupi_get_page_opt( 'p_primary_color' );
		if ( !empty( $p_primary_color ) ) {
            echo '.ct-dots-style2 .slick-dots li.slick-active button, .ct-testimonial-carousel4 .item--icon, #ct-loadding .loading-spin .spinner .bar::after, .ct-social a, .ct-spinner5 > div, .ct-nav-menu1.style4 .ct-main-menu > li:hover > a .ct-menu--plus::before, .ct-nav-menu1.style4 .ct-main-menu > li.current_page_item > a .ct-menu--plus::before, .ct-nav-menu1.style4 .ct-main-menu > li.current-menu-item > a .ct-menu--plus::before, .ct-nav-menu1.style4 .ct-main-menu > li.current_page_ancestor > a .ct-menu--plus::before, .ct-nav-menu1.style4 .ct-main-menu > li.current-menu-ancestor > a .ct-menu--plus::before, .ct-nav-menu1.style4 .ct-main-menu > li:hover > a .ct-menu--plus::after, .ct-nav-menu1.style4 .ct-main-menu > li.current_page_item > a .ct-menu--plus::after, .ct-nav-menu1.style4 .ct-main-menu > li.current-menu-item > a .ct-menu--plus::after, .ct-nav-menu1.style4 .ct-main-menu > li.current_page_ancestor > a .ct-menu--plus::after, .ct-nav-menu1.style4 .ct-main-menu > li.current-menu-ancestor > a .ct-menu--plus::after, .ct-team-carousel2 .ct-slick-carousel .slick-arrow:hover, .ct-team-carousel2 .ct-slick-carousel .slick-arrow:focus, .ct-pricing-single2 .pricing--recommend, .ct-pricing-single2 .pricing--time, .ct-counter-layout1.hover-style2 .ct-counter-line, .ct-progressbar1.style3 .ct-progress-bar, .ct-service-carousel3 .grid-item-inner:hover .item--holder, .ct-spinner3 .double-bounce1, .ct-spinner3 .double-bounce2, body .scroll-top, .ct-modal .ct-modal-close, .ct-service-carousel3 .ct-slick-carousel .slick-arrow:hover, .ct-service-carousel3 .ct-slick-carousel .slick-arrow:focus {
                background-color: '. esc_attr( $p_primary_color ) .';
            }';
            echo '.ct-heading cite, .ct-showcase .item--title span, .ct-team-grid2 .item--details:hover, .ct-team-carousel2 .item--title a:hover, .ct-pricing-single2 .pricing--feature li.active {
                color: '. esc_attr( $p_primary_color ) .';
            }';
            echo '#ct-loadding .loading-spin .spinner .bar {
                border-color: '. esc_attr( $p_primary_color ) .';
            }';
            echo '#ct-loadding .ct-dual-ring::after {
                border-top-color: '. esc_attr( $p_primary_color ) .';
                border-bottom-color: '. esc_attr( $p_primary_color ) .';
            }';
            echo 'body .scroll-top, body .scroll-top:hover, body .scroll-top:focus, .ct-modal .ct-modal-close {
                background-image: none;
                color: #fff;
            }'; 
            echo '.ct-modal .ct-modal-close .ct-icon-close::before, .ct-modal .ct-modal-close .ct-icon-close::after {
                background-color: #fff;
            }';

            echo '.ct-portfolio-carousel3 .item--shape.item--shape4 svg g {
                fill: '. esc_attr( $p_primary_color ) .';
            }';

            echo 'body .ct-team-carousel2 .item--image::before, body .ct-service-carousel3 .item--featured::before {
                background-image: -webkit-gradient(linear, left top, left bottom, from('. grupi_hex_to_rgba( $p_primary_color, 0.7 ) .' 40%), to(rgba(0, 0, 0, 0)));
				background-image: -webkit-linear-gradient(bottom, '. grupi_hex_to_rgba( $p_primary_color, 0.7 ) .' 40%, rgba(0, 0, 0, 0));
				background-image: -moz-linear-gradient(bottom, '. grupi_hex_to_rgba( $p_primary_color, 0.7 ) .' 40%, rgba(0, 0, 0, 0));
				background-image: -ms-linear-gradient(bottom, '. grupi_hex_to_rgba( $p_primary_color, 0.7 ) .' 40%, rgba(0, 0, 0, 0));
				background-image: -o-linear-gradient(bottom, '. grupi_hex_to_rgba( $p_primary_color, 0.7 ) .' 40%, rgba(0, 0, 0, 0));
				background-image: linear-gradient(bottom, '. grupi_hex_to_rgba( $p_primary_color, 0.7 ) .' 40%, rgba(0, 0, 0, 0));
            }';

            echo 'body .ct-info-box5::before {
                background-image: -webkit-gradient(linear, left top, left bottom, from('. grupi_hex_to_rgba( $p_primary_color, 0.6 ) .' 45%), to(rgba(0, 0, 0, 0)));
				background-image: -webkit-linear-gradient(bottom, '. grupi_hex_to_rgba( $p_primary_color, 0.6 ) .' 45%, rgba(0, 0, 0, 0));
				background-image: -moz-linear-gradient(bottom, '. grupi_hex_to_rgba( $p_primary_color, 0.6 ) .' 45%, rgba(0, 0, 0, 0));
				background-image: -ms-linear-gradient(bottom, '. grupi_hex_to_rgba( $p_primary_color, 0.6 ) .' 45%, rgba(0, 0, 0, 0));
				background-image: -o-linear-gradient(bottom, '. grupi_hex_to_rgba( $p_primary_color, 0.6 ) .' 45%, rgba(0, 0, 0, 0));
				background-image: linear-gradient(bottom, '. grupi_hex_to_rgba( $p_primary_color, 0.6 ) .' 45%, rgba(0, 0, 0, 0));
            }';

            echo '.ct-slider-video .slider-video-button, .ct-main-menu > li > a:hover, .ct-main-menu > li > a.current, .ct-main-menu > li.current_page_item > a, .ct-main-menu > li.current-menu-item > a, .ct-main-menu > li.current_page_ancestor > a, .ct-main-menu > li.current-menu-ancestor > a {
                color: '. esc_attr( $p_primary_color ) .';
            }';

            echo '.ct-fancy-box-layout4:hover::before {
                box-shadow: 0 20px 60px '. grupi_hex_to_rgba( $p_primary_color, 0.25 ) .';
                -webkit-box-shadow: 0 20px 60px '. grupi_hex_to_rgba( $p_primary_color, 0.25 ) .';
            }';

            ?>
            @media screen and (min-width: 1200px) { <?php
            	
        	?> }
            @media screen and (max-width: 1199px) { <?php
            	
        	?> } <?php
		}

		$p_gradient_color = grupi_get_page_opt( 'p_gradient_color' );
		if ( !empty($p_gradient_color['from']) && isset($p_gradient_color['from']) && !empty($p_gradient_color['to']) && isset($p_gradient_color['to']) ) {
            echo '.ct-dots-style-line1 .slick-dots li, .ct-info-box6 .ct-info-button, .ct-team-carousel2 .item--image::after, .ct-pricing-single2 .pricing--subtitle span, .ct-counter-layout1 .ct-counter-icon i, .ct-portfolio-carousel3 .item--shape, .ct-portfolio-carousel3 .item--category a, .ct-info-box4 .ct-info-title1 span, body .text-gradient:not(.color-gradient2), .ct-tabs2 .ct-tabs-title .ct-tab-title::before {
                background-image: -webkit-gradient(linear, left top, right top, from('.esc_attr($p_gradient_color['from']).'), to('.esc_attr($p_gradient_color['to']).'));
				background-image: -webkit-linear-gradient(left, '.esc_attr($p_gradient_color['from']).', '.esc_attr($p_gradient_color['to']).');
				background-image: -moz-linear-gradient(left, '.esc_attr($p_gradient_color['from']).', '.esc_attr($p_gradient_color['to']).');
				background-image: -ms-linear-gradient(left, '.esc_attr($p_gradient_color['from']).', '.esc_attr($p_gradient_color['to']).');
				background-image: -o-linear-gradient(left, '.esc_attr($p_gradient_color['from']).', '.esc_attr($p_gradient_color['to']).');
				background-image: linear-gradient(left, '.esc_attr($p_gradient_color['from']).', '.esc_attr($p_gradient_color['to']).');
            }';

            echo '.ct-social-icon2 .ct-social-icon-list {
                background-image: -webkit-gradient(linear, left top, left bottom, from('.esc_attr($p_gradient_color['to']).'), to('.esc_attr($p_gradient_color['from']).'));
				background-image: -webkit-linear-gradient(bottom, '.esc_attr($p_gradient_color['to']).', '.esc_attr($p_gradient_color['from']).');
				background-image: -moz-linear-gradient(bottom, '.esc_attr($p_gradient_color['to']).', '.esc_attr($p_gradient_color['from']).');
				background-image: -ms-linear-gradient(bottom, '.esc_attr($p_gradient_color['to']).', '.esc_attr($p_gradient_color['from']).');
				background-image: -o-linear-gradient(bottom, '.esc_attr($p_gradient_color['to']).', '.esc_attr($p_gradient_color['from']).');
				background-image: linear-gradient(bottom, '.esc_attr($p_gradient_color['to']).', '.esc_attr($p_gradient_color['from']).');
            }';

            echo '.ct-showcase .item--image .btn {
                color: #fff;
            }';

            echo '.ct-info-box6 .ct-info-button-bottom, .ct-showcase .item--image .btn, .btn.btn-reset, .ct-info-box4 .ct-info-button {
                background-image: -webkit-linear-gradient(90deg, '.esc_attr($p_gradient_color['from']).' 0%, '.esc_attr($p_gradient_color['to']).' 50%, '.esc_attr($p_gradient_color['from']).');
				background-image: -moz-linear-gradient(90deg, '.esc_attr($p_gradient_color['from']).' 0%, '.esc_attr($p_gradient_color['to']).' 50%, '.esc_attr($p_gradient_color['from']).');
				background-image: -ms-linear-gradient(90deg, '.esc_attr($p_gradient_color['from']).' 0%, '.esc_attr($p_gradient_color['to']).' 50%, '.esc_attr($p_gradient_color['from']).');
				background-image: -o-linear-gradient(90deg, '.esc_attr($p_gradient_color['from']).' 0%, '.esc_attr($p_gradient_color['to']).' 50%, '.esc_attr($p_gradient_color['from']).');
				background-image: linear-gradient(90deg, '.esc_attr($p_gradient_color['from']).' 0%, '.esc_attr($p_gradient_color['to']).' 50%, '.esc_attr($p_gradient_color['from']).');
            }';

            echo '.ct-social-icon2 .ct-social-box, .ct-slick-arrow-style2 .slick-arrow::after, .ct-team-grid2 .item--inner::before, .ct-fancy-box-layout4 .item--icon i, .box-overlay-gradient::before, .ct-heading .item--sub-title.style-button span:before, .ct-nav-menu2.style3 li a::before, .ct-hidden-sidebar-icon .ct-sidebar-icon {
                background-image: -webkit-linear-gradient(135deg, '.esc_attr($p_gradient_color['from']).', '.esc_attr($p_gradient_color['to']).');
				background-image: -moz-linear-gradient(135deg, '.esc_attr($p_gradient_color['from']).', '.esc_attr($p_gradient_color['to']).');
				background-image: -ms-linear-gradient(135deg, '.esc_attr($p_gradient_color['from']).', '.esc_attr($p_gradient_color['to']).');
				background-image: -o-linear-gradient(135deg, '.esc_attr($p_gradient_color['from']).', '.esc_attr($p_gradient_color['to']).');
				background-image: linear-gradient(135deg, '.esc_attr($p_gradient_color['from']).', '.esc_attr($p_gradient_color['to']).');
				filter: progid:DXImageTransform.Microsoft.gradient(startColorStr="'.esc_attr($p_gradient_color['from']).'", endColorStr="'.esc_attr($p_gradient_color['to']).'");
            }';

            echo '.btn.btn-outline-gradient2, .btn.btn-default-s, .ct-getintouch .ct-getintouch-item a.btn {
                background-image: -webkit-linear-gradient(135deg, '.esc_attr($p_gradient_color['from']).' 0%, '.esc_attr($p_gradient_color['to']).' 50%, '.esc_attr($p_gradient_color['from']).');
				background-image: -moz-linear-gradient(135deg, '.esc_attr($p_gradient_color['from']).' 0%, '.esc_attr($p_gradient_color['to']).' 50%, '.esc_attr($p_gradient_color['from']).');
				background-image: -ms-linear-gradient(135deg, '.esc_attr($p_gradient_color['from']).' 0%, '.esc_attr($p_gradient_color['to']).' 50%, '.esc_attr($p_gradient_color['from']).');
				background-image: -o-linear-gradient(135deg, '.esc_attr($p_gradient_color['from']).' 0%, '.esc_attr($p_gradient_color['to']).' 50%, '.esc_attr($p_gradient_color['from']).');
				background-image: linear-gradient(135deg, '.esc_attr($p_gradient_color['from']).' 0%, '.esc_attr($p_gradient_color['to']).' 50%, '.esc_attr($p_gradient_color['from']).');
				filter: progid:DXImageTransform.Microsoft.gradient(startColorStr="'.esc_attr($p_gradient_color['from']).'", endColorStr="'.esc_attr($p_gradient_color['to']).'");
            }';

            echo '.btn-slider2::before {
                background-image: linear-gradient(#030303, #030303), radial-gradient(circle at top left, '.esc_attr($p_gradient_color['from']).', '.esc_attr($p_gradient_color['to']).');
            }';

            echo '.ct-button-wrapper .btn-slider2::before {
                background-image: linear-gradient(#fff, #fff), radial-gradient(circle at top left, '.esc_attr($p_gradient_color['from']).', '.esc_attr($p_gradient_color['to']).');
            }';

            echo '.ct-tabs2 .ct-tabs-title .ct-tab-title svg {
                fill: '. esc_attr( $p_gradient_color['to'] ) .';
            }';
        }

        $p_gradient_color2 = grupi_get_page_opt( 'p_gradient_color2' );
        if ( !empty($p_gradient_color2['from']) && isset($p_gradient_color2['from']) && !empty($p_gradient_color2['to']) && isset($p_gradient_color2['to']) ) {
            echo '.ct-portfolio-carousel4 .item--featured .item--readmore, .ct-info-box6 .ct-info-button-bottom, .ct-showcase .item--image .btn, .btn.btn-reset, .ct-info-box4 .ct-info-button {
                background-image: -webkit-linear-gradient(90deg, '.esc_attr($p_gradient_color2['from']).' 0%, '.esc_attr($p_gradient_color2['to']).' 50%, '.esc_attr($p_gradient_color2['from']).');
				background-image: -moz-linear-gradient(90deg, '.esc_attr($p_gradient_color2['from']).' 0%, '.esc_attr($p_gradient_color2['to']).' 50%, '.esc_attr($p_gradient_color2['from']).');
				background-image: -ms-linear-gradient(90deg, '.esc_attr($p_gradient_color2['from']).' 0%, '.esc_attr($p_gradient_color2['to']).' 50%, '.esc_attr($p_gradient_color2['from']).');
				background-image: -o-linear-gradient(90deg, '.esc_attr($p_gradient_color2['from']).' 0%, '.esc_attr($p_gradient_color2['to']).' 50%, '.esc_attr($p_gradient_color2['from']).');
				background-image: linear-gradient(90deg, '.esc_attr($p_gradient_color2['from']).' 0%, '.esc_attr($p_gradient_color2['to']).' 50%, '.esc_attr($p_gradient_color2['from']).');
            }';
        }

		/* Custom Css */
		$custom_css = grupi_get_opt( 'site_css' );
		if ( ! empty( $custom_css ) ) {
			echo esc_attr( $custom_css );
		}

		return ob_get_clean();
	}
}

new CSS_Generator();