<?php
$widget->add_render_attribute( 'inner', [
    'class' => 'ct-carousel-inner',
] );

$col_xs = $widget->get_setting('col_xs', '');
$col_sm = $widget->get_setting('col_sm', '');
$col_md = $widget->get_setting('col_md', '');
$col_lg = $widget->get_setting('col_lg', '');
$col_xl = $widget->get_setting('col_xl', '');
$slides_to_scroll = $widget->get_setting('slides_to_scroll', '');

$img_size = $widget->get_setting('img_size');
$arrows = $widget->get_setting('arrows');
$dots = $widget->get_setting('dots');
$pause_on_hover = $widget->get_setting('pause_on_hover');
$autoplay = $widget->get_setting('autoplay', '');
$autoplay_speed = $widget->get_setting('autoplay_speed', '5000');
$infinite = $widget->get_setting('infinite');
$speed = $widget->get_setting('speed', '500');
if (is_rtl()) {
    $carousel_dir = 'true';
} else {
    $carousel_dir = 'false';
}
$img_size_default = '333x167';
if(!empty($img_size)) {
    $img_size_default = $img_size;
}
$widget->add_render_attribute( 'carousel', [
    'class' => 'ct-slick-carousel',
    'data-arrows' => $arrows,
    'data-dots' => $dots,
    'data-pauseOnHover' => $pause_on_hover,
    'data-autoplay' => $autoplay,
    'data-autoplaySpeed' => $autoplay_speed,
    'data-infinite' => $infinite,
    'data-speed' => $speed,
    'data-colxs' => $col_xs,
    'data-colsm' => $col_sm,
    'data-colmd' => $col_md,
    'data-collg' => $col_lg,
    'data-colxl' => $col_xl,
    'data-dir' => $carousel_dir,
    'data-slidesToScroll' => $slides_to_scroll,
] );
$is_new = \Elementor\Icons_Manager::is_migration_allowed();
?>
<?php if(isset($settings['service']) && !empty($settings['service']) && count($settings['service'])): ?>
    <div class="ct-service ct-service-external1 ct-slick-slider">
        <div <?php ct_print_html($widget->get_render_attribute_string( 'inner' )); ?>>
            <div <?php ct_print_html($widget->get_render_attribute_string( 'carousel' )); ?>>
                <?php foreach ($settings['service'] as $key => $value): 
                    $title = isset($value['title']) ? $value['title'] : '';
                    $sub_title = isset($value['sub_title']) ? $value['sub_title'] : '';
                    $link_key = $widget->get_repeater_setting_key( 'title', 'value', $key );
                    if ( ! empty( $value['item_link']['url'] ) ) {
                        $widget->add_render_attribute( $link_key, 'href', $value['item_link']['url'] );

                        if ( $value['item_link']['is_external'] ) {
                            $widget->add_render_attribute( $link_key, 'target', '_blank' );
                        }

                        if ( $value['item_link']['nofollow'] ) {
                            $widget->add_render_attribute( $link_key, 'rel', 'nofollow' );
                        }
                    }
                    $link_attributes = $widget->get_render_attribute_string( $link_key );
                    ?>
                        <div class="slick-slide">
                            <div class="item--inner <?php echo esc_attr($settings['ct_animate']); ?>">
                                <div class="item--line"></div>
                                <div class="item--subtitle"><?php echo esc_html($sub_title); ?></div>
                                <h3 class="item--title">
                                    <?php if ( ! empty( $value['item_link']['url'] ) ) : ?><a <?php echo implode( ' ', [ $link_attributes ] ); ?>><?php endif; ?>
                                        <?php echo esc_attr($title); ?>
                                    <?php if ( ! empty( $value['item_link']['url'] ) ) : ?></a><?php endif; ?>
                                </h3>
                                <?php if ( ! empty( $value['item_link']['url'] ) ) : ?>
                                    <div class="item--readmore">
                                        <a <?php echo implode( ' ', [ $link_attributes ] ); ?>>
                                            <span class="text-gradient">+</span>
                                            <span>+</span>
                                        </a>
                                    </div>
                                <?php endif; ?>
                           </div>
                        </div>
                <?php endforeach; ?>
            </div>
        </div>
    </div>
<?php endif; ?>