<?php

$html_id = ct_get_element_id($settings);
$source = $widget->get_setting('source', '');
$orderby = $widget->get_setting('orderby', 'date');
$order = $widget->get_setting('order', 'desc');
$limit = $widget->get_setting('limit', 6);
$post_ids = $widget->get_setting('post_ids', '');
extract(ct_get_posts_of_grid('portfolio', [
    'source' => $source,
    'orderby' => $orderby,
    'order' => $order,
    'limit' => $limit,
    'post_ids' => $post_ids,
]));

$widget->add_render_attribute( 'inner', [
    'class' => 'ct-carousel-inner',
] );

$col_xs = $widget->get_setting('col_xs', '');
$col_sm = $widget->get_setting('col_sm', '');
$col_md = $widget->get_setting('col_md', '');
$col_lg = $widget->get_setting('col_lg', '');
$col_xl = $widget->get_setting('col_xl', '');
$slides_to_scroll = $widget->get_setting('slides_to_scroll', '');

$img_size = $widget->get_setting('img_size', '');
$show_title = $widget->get_setting('show_title', '');
$show_category = $widget->get_setting('show_category', '');
$show_button = $widget->get_setting('show_button', '');
$button_text = $widget->get_setting('button_text', '');
$btn_link_target = $widget->get_setting('btn_link_target', '');

$arrows = $widget->get_setting('arrows');
$dots = $widget->get_setting('dots');
$pause_on_hover = $widget->get_setting('pause_on_hover');
$autoplay = $widget->get_setting('autoplay');
$autoplay_speed = $widget->get_setting('autoplay_speed', '5000');
$infinite = $widget->get_setting('infinite');
$speed = $widget->get_setting('speed', '500');
if (is_rtl()) {
    $carousel_dir = 'true';
} else {
    $carousel_dir = 'false';
}
$widget->add_render_attribute( 'carousel', [
    'class' => 'ct-slick-carousel ct-slick-arrow-middle',
    'data-arrows' => $arrows,
    'data-dots' => $dots,
    'data-pauseOnHover' => $pause_on_hover,
    'data-autoplay' => $autoplay,
    'data-autoplaySpeed' => $autoplay_speed,
    'data-infinite' => $infinite,
    'data-speed' => $speed,
    'data-colxs' => $col_xs,
    'data-colsm' => $col_sm,
    'data-colmd' => $col_md,
    'data-collg' => $col_lg,
    'data-colxl' => $col_xl,
    'data-dir' => $carousel_dir,
    'data-slidesToScroll' => $slides_to_scroll,
] );
?>
<?php if (is_array($posts)): ?>

<div id="<?php echo esc_attr($html_id) ?>" class="ct-portfolio-carousel3 ct-slick-slider <?php echo esc_attr($settings['style_l3']); ?>">
    <div <?php ct_print_html($widget->get_render_attribute_string( 'inner' )); ?>>
        <div <?php ct_print_html($widget->get_render_attribute_string( 'carousel' )); ?>>
        <?php
            $default_size = '600x500'; 
            if(!empty($img_size)) {
                $default_size = $img_size;
            }
            foreach ($posts as $post): 
            $img_id = get_post_thumbnail_id($post->ID);
            $img = ct_get_image_by_size( array(
                'attach_id'  => $img_id,
                'thumb_size' => $default_size,
            ));
            $thumbnail = $img['thumbnail'];
            $portfolio_custom_link = get_post_meta($post->ID, 'portfolio_custom_link', true);
            if (has_post_thumbnail($post->ID) && wp_get_attachment_image_src(get_post_thumbnail_id($post->ID), false)): ?>
                <div class="carousel-item slick-slide">
                    <div class="grid-item-inner <?php echo esc_attr($settings['ct_animate']); ?>">
                        <div class="item--featured">
                            <?php echo ct_print_html($thumbnail); ?>
                        </div>

                        <?php if($settings['style_l3'] == 'style1') { ?>
                            <div class="item--shape item--shape1"></div>
                            <div class="item--shape item--shape2"></div>
                        <?php } else { ?>
                            <div class="item--shape item--shape3">
                                <svg version="1.0" xmlns="http://www.w3.org/2000/svg" width="506.000000pt" height="901.000000pt" viewBox="0 0 506.000000 901.000000" preserveAspectRatio="xMidYMid meet">
                                    <g transform="translate(0.000000,901.000000) scale(0.100000,-0.100000)"
                                    fill="#fff" stroke="none">
                                        <path d="M747 9003 c-5 -8 -11 -33 -72 -288 -51 -212 -88 -367 -130 -540 -20
                                        -82 -90 -375 -156 -650 -146 -609 -182 -759 -309 -1280 -60 -244 -61 -253 -56
                                        -350 4 -55 11 -199 16 -320 58 -1266 196 -2245 471 -3350 245 -981 543 -1573
                                        964 -1912 157 -126 230 -157 560 -237 324 -78 396 -81 642 -30 804 165 1488
                                        437 1888 749 213 166 371 391 440 630 79 267 17 755 -150 1182 -54 139 -183
                                        395 -266 528 -199 320 -435 562 -1045 1073 -705 589 -890 870 -911 1377 -7
                                        174 5 344 47 670 66 509 74 591 73 820 0 235 -14 354 -68 585 -135 567 -494
                                        1036 -957 1253 -32 15 -103 42 -159 62 l-101 35 -358 0 c-198 0 -361 -3 -363
                                        -7z"/>
                                    </g>
                                </svg>
                            </div>
                            <div class="item--shape item--shape4">
                                <svg version="1.0" xmlns="http://www.w3.org/2000/svg" width="142.000000pt" height="207.000000pt" viewBox="0 0 142.000000 207.000000" preserveAspectRatio="xMidYMid meet">
                                    <g transform="translate(0.000000,207.000000) scale(0.100000,-0.100000)" fill="#000000" stroke="none">
                                        <path d="M105 2064 c-11 -3 -39 -12 -62 -20 l-43 -16 0 -372 0 -373 39 -134
                                        c80 -271 165 -483 287 -718 109 -209 209 -330 322 -387 51 -26 67 -29 152 -29
                                        93 0 97 1 190 47 213 105 369 235 408 341 35 92 28 152 -30 275 -39 83 -117
                                        178 -198 243 -39 31 -128 83 -225 130 -273 133 -314 187 -340 443 -18 177 -28
                                        220 -71 313 -70 148 -203 247 -344 257 -36 3 -74 3 -85 0z"/>
                                    </g>
                                </svg>
                            </div>
                        <?php } ?>
                        
                        <div class="item--meta">
                            <?php if($show_category == 'true'): ?>
                                <div class="item--category">
                                    <?php the_terms( $post->ID, 'portfolio-category', '', ' ' ); ?>
                                </div>
                            <?php endif; ?>
                            <?php if($show_title == 'true'): ?>
                                <h4 class="item--title">
                                    <?php if($show_button == 'true') : ?><a target="<?php echo esc_attr($settings['btn_link_target']); ?>" href="<?php if(!empty($portfolio_custom_link)) { echo esc_url($portfolio_custom_link); } else { echo esc_url(get_permalink( $post->ID )); } ?>"><?php endif; ?>
                                        <?php echo esc_attr(get_the_title($post->ID)); ?>
                                    <?php if($show_button == 'true') : ?></a><?php endif; ?>
                                </h4>
                            <?php endif; ?>
                            <?php if($show_button == 'true') : ?>
                                <div class="item--readmore">
                                    <a target="<?php echo esc_attr($settings['btn_link_target']); ?>" class="btn btn-reset" href="<?php if(!empty($portfolio_custom_link)) { echo esc_url($portfolio_custom_link); } else { echo esc_url(get_permalink( $post->ID )); } ?>">
                                        <?php if(!empty($button_text)) {
                                            echo esc_attr($button_text);
                                        } else {
                                            echo esc_html__('View more', 'grupi');
                                        }?>
                                    </a>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            <?php endif; ?>
        <?php endforeach; ?>
        </div>
    </div>
</div>
<?php endif; ?>