<?php
$default_settings = [
    'number' => '',
    'title' => '',
    'btn_text' => '',
    'btn_link' => '',
    'box_image' => '',
    'color_gradient_from' => '',
    'color_gradient_to' => '',
    'ct_animate' => '',
];
$settings = array_merge($default_settings, $settings);
extract($settings);

if ( ! empty( $btn_link['url'] ) ) {
    $widget->add_render_attribute( 'btn_link', 'href', $btn_link['url'] );

    if ( $btn_link['is_external'] ) {
        $widget->add_render_attribute( 'btn_link', 'target', '_blank' );
    }

    if ( $btn_link['nofollow'] ) {
        $widget->add_render_attribute( 'btn_link', 'rel', 'nofollow' );
    }
}

$is_new = \Elementor\Icons_Manager::is_migration_allowed();
$html_id = ct_get_element_id($settings);
?>
<div id="<?php echo esc_attr($html_id); ?>" class="ct-info-box ct-info-box6 <?php echo esc_attr($ct_animate); ?>" data-wow-delay="<?php echo esc_attr($settings['ct_animate_delay']); ?>ms">
    <div class="ct-inline-css"  data-css="
        <?php if( !empty($color_gradient_from) && !empty($color_gradient_to) ) : ?>
            #<?php echo esc_attr($html_id) ?>.ct-info-box .ct-info-number {
                background-image: -webkit-gradient(linear, left top, left bottom, from(<?php echo esc_attr($color_gradient_from); ?>), to(<?php echo esc_attr($color_gradient_to); ?>));
                background-image: -webkit-linear-gradient(left, <?php echo esc_attr($color_gradient_from); ?>, <?php echo esc_attr($color_gradient_to); ?>);
                background-image: -moz-linear-gradient(left, <?php echo esc_attr($color_gradient_from); ?>, <?php echo esc_attr($color_gradient_to); ?>);
                background-image: -ms-linear-gradient(left, <?php echo esc_attr($color_gradient_from); ?>, <?php echo esc_attr($color_gradient_to); ?>);
                background-image: -o-linear-gradient(left, <?php echo esc_attr($color_gradient_from); ?>, <?php echo esc_attr($color_gradient_to); ?>);
                background-image: linear-gradient(left, <?php echo esc_attr($color_gradient_from); ?>, <?php echo esc_attr($color_gradient_to); ?>);
                filter: progid:DXImageTransform.Microsoft.gradient(startColorStr='<?php echo esc_attr($color_gradient_from); ?>', endColorStr='<?php echo esc_attr($color_gradient_to); ?>');
            }
        <?php endif; ?>">
    </div>
	<div class="ct-infobox-inner">
        <div class="ct-info-meta">
    		<div class="ct-info-number"><?php echo esc_attr($number); ?></div>
            <?php if ( ! empty( $btn_text ) ) { ?>
    			<a class="ct-info-button btn btn-outline" <?php ct_print_html($widget->get_render_attribute_string( 'btn_link' )); ?>><?php echo esc_attr($btn_text); ?></a>
    		<?php } ?>
        </div>
        <div class="ct-info-hover">
            <h4 class="ct-info-title h4-title"><?php echo ct_print_html($title); ?></h4>
            <?php if ( ! empty( $btn_text ) ) { ?>
                <a class="ct-info-button-bottom btn" <?php ct_print_html($widget->get_render_attribute_string( 'btn_link' )); ?>><?php echo esc_attr($btn_text); ?></a>
            <?php } ?>
        </div>
	    <?php if(!empty($box_image['url'])) : ?>
            <div class="image-overlay">
                <div class="bg-image" style="background-image:url(<?php echo esc_url($box_image['url']); ?>);"></div>
            </div>
        <?php endif; ?>
    </div>
</div>