<?php
$widget->add_render_attribute( 'selected_icon', 'class' );
$has_icon = ! empty( $settings['selected_icon'] );
if ( $has_icon ) {
    $widget->add_render_attribute( 'i', 'class', $settings['selected_icon'] );
    $widget->add_render_attribute( 'i', 'aria-hidden', 'true' );
}

$widget->add_render_attribute( 'description_text', 'class', 'item--description h4-desc' );
$widget->add_inline_editing_attributes( 'title_text', 'none' );
$widget->add_inline_editing_attributes( 'description_text' );
$is_new = \Elementor\Icons_Manager::is_migration_allowed();
$html_id = ct_get_element_id($settings);
if ( ! empty( $settings['item_link']['url'] ) ) {
    $widget->add_render_attribute( 'button', 'href', $settings['item_link']['url'] );

    if ( $settings['item_link']['is_external'] ) {
        $widget->add_render_attribute( 'button', 'target', '_blank' );
    }

    if ( $settings['item_link']['nofollow'] ) {
        $widget->add_render_attribute( 'button', 'rel', 'nofollow' );
    }
}
?>
<div id="<?php echo esc_attr($html_id) ?>" class="ct-fancy-box ct-fancy-box-layout7 <?php echo esc_attr($settings['ct_animate']); ?>" data-wow-delay="<?php echo esc_attr($settings['ct_animate_delay']); ?>ms">
    <div class="ct-inline-css"  data-css="
        <?php if( !empty($settings['color_gradient_from']) && !empty($settings['color_gradient_to']) ) : ?>
            #<?php echo esc_attr($html_id) ?>.ct-fancy-box .item--icon i:nth-child(1), #<?php echo esc_attr($html_id) ?>.ct-fancy-box .item--inner::before {
                background-image: -webkit-linear-gradient(90deg, <?php echo esc_attr($settings['color_gradient_from']); ?>, <?php echo esc_attr($settings['color_gradient_to']); ?>)!important;
                background-image: -moz-linear-gradient(90deg, <?php echo esc_attr($settings['color_gradient_from']); ?>, <?php echo esc_attr($settings['color_gradient_to']); ?>)!important;
                background-image: -ms-linear-gradient(90deg, <?php echo esc_attr($settings['color_gradient_from']); ?>, <?php echo esc_attr($settings['color_gradient_to']); ?>)!important;
                background-image: -o-linear-gradient(90deg, <?php echo esc_attr($settings['color_gradient_from']); ?>, <?php echo esc_attr($settings['color_gradient_to']); ?>)!important;
                background-image: linear-gradient(90deg, <?php echo esc_attr($settings['color_gradient_from']); ?>, <?php echo esc_attr($settings['color_gradient_to']); ?>)!important;
                filter: progid:DXImageTransform.Microsoft.gradient(startColorStr='<?php echo esc_attr($settings['color_gradient_from']); ?>', endColorStr='<?php echo esc_attr($settings['color_gradient_to']); ?>')!important;
                background-color: transparent !important;
            }
        <?php endif; ?>">
    </div>
    <div class="item--inner">
        <?php if ( $settings['icon_type'] == 'icon' && $has_icon ) : ?>
            <div class="item--icon">
                <?php if($is_new):
                    \Elementor\Icons_Manager::render_icon( $settings['selected_icon'], [ 'aria-hidden' => 'true' ] );
                    \Elementor\Icons_Manager::render_icon( $settings['selected_icon'], [ 'aria-hidden' => 'true' ] );
                    else: ?>
                    <i <?php ct_print_html($widget->get_render_attribute_string( 'i' )); ?>></i>
                <?php endif; ?>
            </div>
        <?php endif; ?>
        <?php if ( $settings['icon_type'] == 'image' && !empty($settings['icon_image']['id']) ) : ?>
            <div class="item--icon">
                <?php $img_icon  = ct_get_image_by_size( array(
                        'attach_id'  => $settings['icon_image']['id'],
                        'thumb_size' => 'full',
                    ) );
                    $thumbnail_icon    = $img_icon['thumbnail'];
                echo ct_print_html($thumbnail_icon); ?>
            </div>
        <?php endif; ?>
         <h4 class="item--title h4-title">
            <span><?php echo ct_print_html($settings['title_text']); ?></span>
        </h4>
        <div <?php ct_print_html($widget->get_render_attribute_string( 'description_text' )); ?>><?php echo ct_print_html($settings['description_text']); ?></div>
        <?php if ( ! empty( $settings['item_link']['url'] ) ) { ?><a class="item--link" <?php ct_print_html($widget->get_render_attribute_string( 'button' )); ?>></a><?php } ?>
    </div>
</div>