<?php

$html_id = ct_get_element_id($settings);
$source = $widget->get_setting('source', '');
$orderby = $widget->get_setting('orderby', 'date');
$order = $widget->get_setting('order', 'desc');
$limit = $widget->get_setting('limit', 6);
$post_ids = $widget->get_setting('post_ids', '');
extract(ct_get_posts_of_grid('post', [
    'source' => $source,
    'orderby' => $orderby,
    'order' => $order,
    'limit' => $limit,
    'post_ids' => $post_ids,
]));

$widget->add_render_attribute( 'inner', [
    'class' => 'ct-carousel-inner',
] );

$col_xs = $widget->get_setting('col_xs', '');
$col_sm = $widget->get_setting('col_sm', '');
$col_md = $widget->get_setting('col_md', '');
$col_lg = $widget->get_setting('col_lg', '');
$col_xl = $widget->get_setting('col_xl', '');
$slides_to_scroll = $widget->get_setting('slides_to_scroll', '');


$arrows = $widget->get_setting('arrows');
$dots = $widget->get_setting('dots');
$pause_on_hover = $widget->get_setting('pause_on_hover');
$autoplay = $widget->get_setting('autoplay');
$autoplay_speed = $widget->get_setting('autoplay_speed', '5000');
$infinite = $widget->get_setting('infinite');
$speed = $widget->get_setting('speed', '500');

$show_category = $widget->get_setting('show_category');
$show_date = $widget->get_setting('show_date');
$show_button = $widget->get_setting('show_button');

if (is_rtl()) {
    $carousel_dir = 'true';
} else {
    $carousel_dir = 'false';
}

$widget->add_render_attribute( 'carousel', [
    'class' => 'ct-slick-carousel ct-slick-arrow-middle',
    'data-arrows' => $arrows,
    'data-dots' => $dots,
    'data-pauseOnHover' => $pause_on_hover,
    'data-autoplay' => $autoplay,
    'data-autoplaySpeed' => $autoplay_speed,
    'data-infinite' => $infinite,
    'data-speed' => $speed,
    'data-dir' => $carousel_dir,
    'data-colxs' => $col_xs,
    'data-colsm' => $col_sm,
    'data-colmd' => $col_md,
    'data-collg' => $col_lg,
    'data-colxl' => $col_xl,
    'data-slidesToScroll' => $slides_to_scroll,
] );

$title_tag = $widget->get_setting('title_tag', 'h3');

$images_size = '800x495';
if(!empty($img_size)) {
    $images_size = $img_size;
}
if (is_array($posts)): ?>
<div id="<?php echo esc_attr($html_id) ?>" class="ct-blog-carousel-layout2 ct-slick-slider ct-slick-arrow-style2">
    <div <?php ct_print_html($widget->get_render_attribute_string( 'inner' )); ?>>
        <div <?php ct_print_html($widget->get_render_attribute_string( 'carousel' )); ?>>

        <?php
            foreach ($posts as $key => $post):
            $img_id       = get_post_thumbnail_id( $post->ID );
            $img          = ct_get_image_by_size( array(
                'attach_id'  => $img_id,
                'thumb_size' => $images_size,
            ) );
            $thumbnail    = $img['thumbnail'];
            $author = get_user_by('id', $post->post_author);
            $post_gradient_color = get_post_meta($post->ID, 'post_gradient_color', true);
            ?>
            <div class="carousel-item slick-slide">
                <div id="<?php echo esc_attr($html_id.$key); ?>" class="grid-item-inner <?php echo esc_attr($settings['ct_animate']); ?>">
                    <div class="ct-inline-css"  data-css="
                        <?php if( !empty($post_gradient_color['from']) && !empty($post_gradient_color['to']) ) : ?>
                            .ct-blog-carousel-layout2 #<?php echo esc_attr($html_id.$key); ?> .item--meta .item--category, .ct-blog-carousel-layout2 #<?php echo esc_attr($html_id.$key); ?> .item--readmore  {
                                background-image: -webkit-linear-gradient(135deg, <?php echo esc_attr($post_gradient_color['from']); ?>, <?php echo esc_attr($post_gradient_color['to']); ?>)!important;
                                background-image: -moz-linear-gradient(135deg, <?php echo esc_attr($post_gradient_color['from']); ?>, <?php echo esc_attr($post_gradient_color['to']); ?>)!important;
                                background-image: -ms-linear-gradient(135deg, <?php echo esc_attr($post_gradient_color['from']); ?>, <?php echo esc_attr($post_gradient_color['to']); ?>)!important;
                                background-image: -o-linear-gradient(135deg, <?php echo esc_attr($post_gradient_color['from']); ?>, <?php echo esc_attr($post_gradient_color['to']); ?>)!important;
                                background-image: linear-gradient(135deg, <?php echo esc_attr($post_gradient_color['from']); ?>, <?php echo esc_attr($post_gradient_color['to']); ?>)!important;
                                filter: progid:DXImageTransform.Microsoft.gradient(startColorStr='<?php echo esc_attr($post_gradient_color['from']); ?>', endColorStr='<?php echo esc_attr($post_gradient_color['to']); ?>')!important;
                                background-color: transparent !important;
                            }
                            .ct-blog-carousel-layout2 #<?php echo esc_attr($html_id.$key); ?>:hover .item--holder {
                                box-shadow: 0 15px 21px <?php echo grupi_hex_to_rgba( $post_gradient_color['to'], 0.2 ) ?>;
                                -webkit-box-shadow: 0 15px 21px <?php echo grupi_hex_to_rgba( $post_gradient_color['to'], 0.12 ) ?>;
                            }
                            .ct-blog-carousel-layout2 #<?php echo esc_attr($html_id.$key); ?> .item--featured a::before {
                                background-image: -webkit-gradient(linear, left top, left bottom, from(<?php echo grupi_hex_to_rgba( $post_gradient_color['to'], 0.65 ) ?> 40%), to(rgba(0, 0, 0, 0)));
                                background-image: -webkit-linear-gradient(bottom, <?php echo grupi_hex_to_rgba( $post_gradient_color['to'], 0.65 ) ?> 40%, rgba(0, 0, 0, 0));
                                background-image: -moz-linear-gradient(bottom, <?php echo grupi_hex_to_rgba( $post_gradient_color['to'], 0.65 ) ?> 40%, rgba(0, 0, 0, 0));
                                background-image: -ms-linear-gradient(bottom, <?php echo grupi_hex_to_rgba( $post_gradient_color['to'], 0.65 ) ?> 40%, rgba(0, 0, 0, 0));
                                background-image: -o-linear-gradient(bottom, <?php echo grupi_hex_to_rgba( $post_gradient_color['to'], 0.65 ) ?> 40%, rgba(0, 0, 0, 0));
                                background-image: linear-gradient(bottom, <?php echo grupi_hex_to_rgba( $post_gradient_color['to'], 0.65 ) ?> 40%, rgba(0, 0, 0, 0));
                                filter: progid:DXImageTransform.Microsoft.gradient(startColorStr='<?php echo grupi_hex_to_rgba( $post_gradient_color['to'], 0.65 ) ?> 40%', endColorStr='rgba(0, 0, 0, 0)');
                            }
                        <?php endif; ?>">
                    </div>

                    <?php if (has_post_thumbnail($post->ID) && wp_get_attachment_image_src(get_post_thumbnail_id($post->ID), false)): ?>
                        <div class="item--featured" data-cursor-icon="arrow-right">
                            <a href="<?php echo esc_url(get_permalink( $post->ID )); ?>"><?php echo wp_kses_post($thumbnail); ?></a>
                        </div>
                    <?php endif; ?>
                    <div class="item--holder">
                        <?php if($show_date == 'true' || $show_category == 'true' ) : ?>
                            <ul class="item--meta">
                                <?php if($show_category == 'true') : ?>
                                    <li class="item--category">
                                        <?php the_terms( $post->ID, 'category', '', ', ' ); ?>
                                    </li>
                                <?php endif; ?>
                                <?php if($show_date == 'true'): ?>
                                    <li class="item-date"><i class="caseicon-calendar"></i><?php $date_formart = get_option('date_format'); echo get_the_date($date_formart, $post->ID); ?></li>
                                <?php endif; ?>
                            </ul>
                        <?php endif; ?>
                        <h3 class="item--title h3-title"><a href="<?php echo esc_url(get_permalink( $post->ID )); ?>"><?php echo esc_attr(get_the_title($post->ID)); ?></a></h3>
                        <?php if($show_button == 'true') : ?>
                            <a class="item--readmore" href="<?php echo esc_url(get_permalink( $post->ID )); ?>">
                                <i class="caseicon-double-chevron-right"></i>
                            </a>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        <?php endforeach; ?>
        </div>
    </div>
</div>
<?php endif; ?>