<?php
ct_add_custom_widget(
    array(
        'name' => 'ct_social',
        'title' => esc_html__('Case Social Icons', 'grupi'),
        'icon' => 'eicon-social-icons',
        'categories' => array(Case_Theme_Core::CT_CATEGORY_NAME),
        'scripts' => [
            'ct-elementor-js',
            'ct-inline-css-js',
        ],
        'params' => array(
            'sections' => array(
                array(
                    'name' => 'section_icon',
                    'label' => esc_html__('Icons', 'grupi'),
                    'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
                    'controls' => array(
                        array(
                            'name' => 'layout',
                            'label' => esc_html__('Style', 'grupi' ),
                            'type' => \Elementor\Controls_Manager::SELECT,
                            'options' => [
                                '1' => 'Layout 1',
                                '2' => 'Layout 2',
                            ],
                            'default' => '1',
                        ),
                        array(
                            'name' => 'icons',
                            'label' => esc_html__('Icons', 'grupi'),
                            'type' => \Elementor\Controls_Manager::REPEATER,
                            'condition' => [
                                'layout' => ['1'],
                            ],
                            'controls' => array(
                                array(
                                    'name' => 'ct_icon',
                                    'label' => esc_html__('Icon', 'grupi' ),
                                    'type' => \Elementor\Controls_Manager::ICONS,
                                    'fa4compatibility' => 'icon',
                                    'default' => [
                                        'value' => 'fas fa-star',
                                        'library' => 'fa-solid',
                                    ],
                                    'recommended' => [
                                    'fa-brands' => [
                                        'android',
                                        'apple',
                                        'behance',
                                        'bitbucket',
                                        'codepen',
                                        'delicious',
                                        'deviantart',
                                        'digg',
                                        'dribbble',
                                        'elementor',
                                        'facebook',
                                        'flickr',
                                        'foursquare',
                                        'free-code-camp',
                                        'github',
                                        'gitlab',
                                        'globe',
                                        'houzz',
                                        'instagram',
                                        'jsfiddle',
                                        'linkedin',
                                        'medium',
                                        'meetup',
                                        'mix',
                                        'mixcloud',
                                        'odnoklassniki',
                                        'pinterest',
                                        'product-hunt',
                                        'reddit',
                                        'shopping-cart',
                                        'skype',
                                        'slideshare',
                                        'snapchat',
                                        'soundcloud',
                                        'spotify',
                                        'stack-overflow',
                                        'steam',
                                        'telegram',
                                        'thumb-tack',
                                        'tripadvisor',
                                        'tumblr',
                                        'twitch',
                                        'twitter',
                                        'viber',
                                        'vimeo',
                                        'vk',
                                        'weibo',
                                        'weixin',
                                        'whatsapp',
                                        'wordpress',
                                        'xing',
                                        'yelp',
                                        'youtube',
                                        '500px',
                                    ],
                                    'fa-solid' => [
                                        'envelope',
                                        'link',
                                        'rss',
                                    ],
                                ],
                                ),
                                array(
                                    'name' => 'icon_label',
                                    'label' => esc_html__('Icon Text', 'grupi' ),
                                    'type' => \Elementor\Controls_Manager::TEXT,
                                    'label_block' => true,

                                ),
                                array(
                                    'name' => 'icon_link',
                                    'label' => esc_html__('Icon Link', 'grupi'),
                                    'type' => \Elementor\Controls_Manager::URL,
                                ),
                                array(
                                    'name' => 'box_bg_color',
                                    'label' => esc_html__( 'Box Background Color', 'grupi' ),
                                    'type' => \Elementor\Controls_Manager::COLOR,
                                    'description' => 'Apply style 2.',
                                ),
                            ),
                            'title_field' => '{{{ icon_label }}}',
                        ),
                        
                        

                        array(
                            'name' => 'position',
                            'label' => esc_html__('Position', 'grupi' ),
                            'type' => \Elementor\Controls_Manager::SELECT,
                            'options' => [
                                'none' => 'None',
                                'top-left' => 'Top Left',
                                'top-right' => 'Top Right',
                                'bottom-left' => 'Bottom Left',
                            ],
                            'default' => 'none',
                            'condition' => [
                                'layout' => ['1'],
                            ],
                        ),
                        array(
                            'name' => 'style',
                            'label' => esc_html__('Style', 'grupi' ),
                            'type' => \Elementor\Controls_Manager::SELECT,
                            'options' => [
                                'style1' => 'Style 1',
                                'style2' => 'Style 2',
                            ],
                            'default' => 'style1',
                            'condition' => [
                                'layout' => ['1'],
                            ],
                        ),
                        array(
                            'name' => 'icon_align',
                            'label' => esc_html__('Alignment', 'grupi' ),
                            'type' => \Elementor\Controls_Manager::CHOOSE,
                            'control_type' => 'responsive',
                            'options' => [
                                'left' => [
                                    'title' => esc_html__('Left', 'grupi' ),
                                    'icon' => 'fa fa-align-left',
                                ],
                                'center' => [
                                    'title' => esc_html__('Center', 'grupi' ),
                                    'icon' => 'fa fa-align-center',
                                ],
                                'right' => [
                                    'title' => esc_html__('Right', 'grupi' ),
                                    'icon' => 'fa fa-align-right',
                                ],
                            ],
                            'selectors' => [
                                '{{WRAPPER}} .ct-social-icon1.position-none' => 'text-align: {{VALUE}};',
                            ],
                            'condition' => [
                                'position' => 'none',
                                'style' => 'style1',
                                'layout' => '1',
                            ],
                        ),
                        array(
                            'name' => 'icon_color',
                            'label' => esc_html__( 'Icon Color', 'grupi' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'default' => '',
                            'selectors' => [
                                '{{WRAPPER}} .ct-social-icon1 a, {{WRAPPER}} .ct-social-icon1 a i' => 'color: {{VALUE}};',
                            ],
                            'condition' => [
                                'layout' => ['1'],
                            ],
                        ),
                        array(
                            'name' => 'icon_color_hover',
                            'label' => esc_html__( 'Icon Color Hover', 'grupi' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'default' => '',
                            'selectors' => [
                                '{{WRAPPER}} .ct-social-icon1 a:hover, {{WRAPPER}} .ct-social-icon1 a:hover i' => 'color: {{VALUE}};',
                            ],
                            'condition' => [
                                'layout' => ['1'],
                            ],
                        ),
                        array(
                            'name' => 'icon_space',
                            'label' => esc_html__('Icon Spacer', 'grupi' ),
                            'type' => \Elementor\Controls_Manager::SLIDER,
                            'control_type' => 'responsive',
                            'size_units' => [ 'px' ],
                            'range' => [
                                'px' => [
                                    'min' => 0,
                                    'max' => 300,
                                ],
                            ],
                            'selectors' => [
                                '{{WRAPPER}} .ct-social-icon1 a' => 'margin-right: {{SIZE}}{{UNIT}};',
                            ],
                            'condition' => [
                                'style' => ['style1'],
                                'layout' => ['1'],
                            ],
                        ),

                        /* Layout 2 */
                        array(
                            'name' => 'icons_l2',
                            'label' => esc_html__('Icons', 'grupi'),
                            'type' => \Elementor\Controls_Manager::REPEATER,
                            'condition' => [
                                'layout' => ['2'],
                            ],
                            'controls' => array(
                                array(
                                    'name' => 'ct_icon_l2',
                                    'label' => esc_html__('Icon', 'grupi' ),
                                    'type' => \Elementor\Controls_Manager::ICONS,
                                    'fa4compatibility' => 'icon',
                                    'default' => [
                                        'value' => 'fas fa-star',
                                        'library' => 'fa-solid',
                                    ],
                                ),
                                array(
                                    'name' => 'icon_link_l2',
                                    'label' => esc_html__('Icon Link', 'grupi'),
                                    'type' => \Elementor\Controls_Manager::URL,
                                ),
                            ),
                        ),
                        array(
                            'name' => 'wg_label',
                            'label' => esc_html__('Label', 'grupi' ),
                            'type' => \Elementor\Controls_Manager::TEXT,
                            'label_block' => true,
                            'condition' => [
                                'layout' => ['2'],
                            ],
                        ),
                    ),
                ),
            ),
        ),
    ),
    get_template_directory() . '/elementor/core/widgets/'
);