<?php
ct_add_custom_widget(
    array(
        'name' => 'ct_angle',
        'title' => esc_html__('Case Angle Row', 'grupi'),
        'icon' => 'eicon-filter',
        'categories' => array(Case_Theme_Core::CT_CATEGORY_NAME),
        'scripts' => array(),
        'params' => array(
            'sections' => array(
                array(
                    'name' => 'source_section',
                    'label' => esc_html__('Source Settings', 'grupi'),
                    'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
                    'controls' => array(
                        array(
                            'name' => 'angle_color',
                            'label' => esc_html__('Color', 'grupi' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .ct-angle svg, {{WRAPPER}} .ct-angle .ct-angle-square' => 'fill: {{VALUE}};background-color: {{VALUE}};',
                            ],
                        ),
                        array(
                            'name' => 'angle_height',
                            'label' => esc_html__('Height', 'grupi' ),
                            'type' => \Elementor\Controls_Manager::SLIDER,
                            'size_units' => [ 'px' ],
                            'default' => [
                                'size' => 90,
                            ],
                            'range' => [
                                'px' => [
                                    'min' => 0,
                                    'max' => 1000,
                                ],
                            ],
                            'selectors' => [
                                '{{WRAPPER}} .ct-angle svg' => 'height: {{SIZE}}{{UNIT}};;',
                            ],
                        ),
                        array(
                            'name' => 'responsive',
                            'label' => esc_html__('Responsive', 'grupi' ),
                            'type' => \Elementor\Controls_Manager::SELECT,
                            'options' => [
                                'lg' => 'Default',
                                'md' => 'Hide Tablet',
                                'sm' => 'Hide Mobile',
                            ],
                            'default' => 'lg',
                        ),
                    ),
                ),
            ),
        ),
    ),
    get_template_directory() . '/elementor/core/widgets/'
);